*
*  Fat Editor icon file
*
*
	.include	"fatequ.s"
*
*
*
	.globl	bigpalt
	.globl	handform
	.globl	iconlist,icons
	.globl	curslist
	.globl	fatpxlw,fatpxlh
	.globl	liconlst
	.globl	brshform
	.globl	neopaint
*
*
curslist:
	.dc.l	jackfrm		;0 jack knife
	.dc.l	handform	;1 hand
	.dc.l	plusform	;2 copybox
	.dc.l	textform	;3 mr. T
	.dc.l	penclfrm	;0 pencil
*
	.dc.l	plusform	;5 linedraw
	.dc.l	buktform	;6 bucket
	.dc.l	plusform	;7
	.dc.l	plusform	;8
	.dc.l	brshform	;9 brush
*
	.dc.l	plusform	;A diskette
	.dc.l	plusform	;B animate
	.dc.l	plusform	;C shapes
	.dc.l	erasform	;D eraser
	.dc.l	brshform	;E spray can
*
	.dc.l	ptrform		;F pointer form
*	
*	
*  Cursor forms..
*
penclfrm:
	.dc.w	0		;x-coord of hot spot
	.dc.w	0		;y-coord of hot spot
	.dc.w	1		;must be 1
	.dc.w	0		;mask color index (usually 0)
	.dc.w	1		;data color index (usually 1)
*
*  mask grafix..
*
	.dc.w	$7800,$fc00,$fe00,$ff00,$7f80,$3fc0,$1fe0,$0ff0
	.dc.w	$07f8,$03fc,$01fe,$00ff,$007e,$003c,$0018,$0000
*
*  data grafix..
*
	.dc.w	$0000,$7800,$7400,$6200,$3100,$1880,$0c40,$0620
	.dc.w	$0310,$0188,$00c4,$0066,$003c,$0018,$0000,$0000
*
erasform:
	.dc.w	5		;x-coord of hot spot
	.dc.w	7		;y-coord of hot spot
	.dc.w	1		;must be 1
	.dc.w	0		;mask color index (usually 0)
	.dc.w	1		;data color index (usually 1)
*
*  mask grafix..
*
	.dc.w	$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0
	.dc.w	$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$0000
*
*  data grafix..
*
	.dc.w	$FFE0,$8020,$8020,$8020,$8020,$8020,$8020,$8020
	.dc.w	$8020,$8020,$8020,$8020,$8020,$8020,$FFE0,$0000
*
*
handform:
	.dc.w	7
	.dc.w	7
	.dc.w	1
	.dc.w	0
	.dc.w	1
*
	.dc.w	$0300,$1fb0,$3ff8,$3ffc,$7ffe,$fffe,$fffe,$7fff
	.dc.w	$7fff,$ffff,$ffff,$7fff,$3ffe,$0ffc,$01f8,$0030
*
	.dc.w	%0000001100000000
	.dc.w	%0001110010110000
	.dc.w	%0010010001001000
	.dc.w	%0010001000100100
	.dc.w	%0111000100010010
	.dc.w	%1001100010000010
	.dc.w	%1000010000000010
	.dc.w	%0100001000000001
	.dc.w	%0111000000000001
	.dc.w	%1001100000000001
	.dc.w	%1000010000000001
	.dc.w	%0100000000000000
	.dc.w	%0011000000000000
	.dc.w	%0000111000000000
	.dc.w	%0000000111000000
	.dc.w	%0000000000110000
*
*
plusform:
	.dc.w	7
	.dc.w	8
	.dc.w	1
	.dc.w	0
	.dc.w	1
*
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0011111011111000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
*
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000100000000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0011111011111000
	.dc.w	%0100000000000100
	.dc.w	%0011111011111000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0000001010000000
	.dc.w	%0000000100000000
	.dc.w	%0000000000000000
*
buktform:
	.dc.w	14
	.dc.w	14
	.dc.w	1
	.dc.w	0
	.dc.w	1
*
	.dc.w	$01c0,$03f0,$07f8,$0ffc,$1ffe,$3ffe,$7fff,$ffff
	.dc.w	$ffff,$ffff,$ffff,$7fe7,$3fc7,$1f82,$0707,$0002
*
	.dc.w	$0000,$01c0,$0330,$0708,$0c84,$185c,$303e,$601e
	.dc.w	$402e,$4056,$60a6,$3142,$1a82,$0700,$0002,$0000
*
textform:
	.dc.w	6
	.dc.w	13
	.dc.w	1
	.dc.w	0
	.dc.w	1
*
	.dc.w	$7ff0,$7ff0,$7ff0,$0700,$0700,$0700,$0700,$0700
	.dc.w	$0700,$0700,$0700,$0700,$0700,$7ff0,$7ff0,$7ff0
*
	.dc.w	$0000,$3de0,$0200,$0200,$0200,$0200,$0200,$0200
	.dc.w	$0200,$0200,$0200,$0200,$0200,$0200,$3de0,$0000
*
*  dummy form to be built by spray/brush init..
*
brshform:
	.dc.w	0
	.dc.w	0
	.dc.w	1
	.dc.w	0
	.dc.w	1
*
	.dc.w	0,0,0,0,0,0,0,0
	.dc.w	0,0,0,0,0,0,0,0
*
	.dc.w	0,0,0,0,0,0,0,0
	.dc.w	0,0,0,0,0,0,0,0
*
*
ptrform:
	.dc.w	1
	.dc.w	1
	.dc.w	1
	.dc.w	0
	.dc.w	1
*

	.dc.w	%1110000000000000
	.dc.w	%1111000000000000
	.dc.w	%1111100000000000
	.dc.w	%1111110000000000
	.dc.w	%1111111000000000
	.dc.w	%1111111100000000
	.dc.w	%1111111110000000
	.dc.w	%1111111111000000
	.dc.w	%1111111111000000
	.dc.w	%1111111111000000
	.dc.w	%1111111100000000
	.dc.w	%1111111100000000
	.dc.w	%1110111110000000
	.dc.w	%0000111110000000
	.dc.w	%0000011110000000
	.dc.w	%0000011110000000
*
	.dc.w	%0000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0110000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111100000000000
	.dc.w	%0111110000000000
	.dc.w	%0111111000000000
	.dc.w	%0111111100000000
	.dc.w	%0111111110000000
	.dc.w	%0111110000000000
	.dc.w	%0110110000000000
	.dc.w	%0100011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000001100000000
	.dc.w	%0000001100000000
	.dc.w	%0000000000000000
*
*
*
jackfrm:
	.dc.w	2		;x-coord of hot spot
	.dc.w	15		;y-coord of hot spot
	.dc.w	1		;must be 1
	.dc.w	0		;mask color index (usually 0)
	.dc.w	1		;data color index (usually 1)
*
*  mask grafix..
*
	.dc.w	$3800,$7C00,$FE00,$FF00,$FF80,$7FC0,$7FE0,$7FF0
	.dc.w	$7FF8,$7FFC,$7FFE,$7FFF,$7FFF,$7CFF,$787E,$703C
*
*
*  data grafix..
*
	.dc.w	$0000,$3800,$6400,$5200,$4500,$2A80,$3540,$2AA0
	.dc.w	$2D50,$26A8,$2354,$25A2,$24CA,$2866,$303C,$2000
*
*
*
*  Left icon block list of icons
*
*  0 = null icon
*  
liconlst:
	.dc.b	15,7,8,9,6	;
	.dc.b	10,11,0,68,13
	.dc.b	14,0,19,18,12	;remove 67,19 for release
*	.dc.b	14,67,0,18,12
*	.dc.b	14,0,0,18,12
*
	.even
*
*  Offsets to available icons
*
iconlist:
	.dc.w	block-icons	;0
	.dc.w	block1-icons	;1
	.dc.w	block2-icons	;2
	.dc.w	block3-icons	;3
	.dc.w	block4-icons	;4
	.dc.w	colorscr-icons	;5
	.dc.w	pencil-icons	;6
	.dc.w	hand-icons	;7
	.dc.w	copybox-icons	;8
	.dc.w	mrtee-icons	;9
	.dc.w	linedrw-icons	;10
	.dc.w	bucket-icons	;11
	.dc.w	sprayc-icons	;12
	.dc.w	brush-icons	;13
	.dc.w	disket-icons	;14
*
	.dc.w	jacknife-icons	;15
	.dc.w	exitboxh-icons	;16
	.dc.w	exitboxf-icons	;17
	.dc.w	erase-icons	;18
	.dc.w	shapes-icons	;19
	.dc.w	alinleft-icons	;20
	.dc.w	alinmid-icons	;21
	.dc.w	alinrite-icons	;22
	.dc.w	larrow-icons	;23
	.dc.w	rarrow-icons	;24
	.dc.w	colblok-icons	;25
*
*
	.dc.w	brush1-icons	;26
	.dc.w	brush2-icons	;27
	.dc.w	brush3-icons	;28
	.dc.w	brush4-icons	;29
	.dc.w	brush5-icons	;30
	.dc.w	brush6-icons	;31
	.dc.w	brush7-icons	;32
	.dc.w	brush8-icons	;33
	.dc.w	brush9-icons	;34
	.dc.w	brush10-icons	;35
	.dc.w	brush11-icons	;36
	.dc.w	brush12-icons	;37
	.dc.w	brush13-icons	;38
	.dc.w	brush14-icons	;39
	.dc.w	brush15-icons	;40
	.dc.w	brush16-icons	;41
	.dc.w	brush17-icons	;42
	.dc.w	brush18-icons	;43
	.dc.w	brush19-icons	;44
	.dc.w	brush20-icons	;45
	.dc.w	brush21-icons	;46
	.dc.w	brush22-icons	;47
	.dc.w	brush23-icons	;48
	.dc.w	brush24-icons	;49
	.dc.w	brush25-icons	;50
	.dc.w	brush26-icons	;51
	.dc.w	brush27-icons	;52
	.dc.w	brush28-icons	;53
	.dc.w	brush29-icons	;54
	.dc.w	brush30-icons	;55
	.dc.w	brush31-icons	;56
	.dc.w	brush32-icons	;57
	.dc.w	brush33-icons	;58
	.dc.w	brush34-icons	;59
	.dc.w	brush35-icons	;60
	.dc.w	brush36-icons	;61
	.dc.w	brush37-icons	;62
	.dc.w	brush38-icons	;63
*
	.dc.w	replace-icons	;64
	.dc.w	trans-icons	;65
*
	.dc.w	eraser-icons	;66
*
	.dc.w	animate-icons	;67
	.dc.w	misc-icons	;68
*
	.dc.w	upara-icons	;69
	.dc.w	dwnara-icons	;70
*
	.dc.w	lftara-icons	;71
	.dc.w	rgtara-icons	;72
*
	.dc.w	lilcpybx-icons	;73
*
	.dc.w	cswap-icons	;74
	.dc.w	stretch-icons	;75
*
	.dc.w	orect-icons	;76
	.dc.w	orndrect-icons	;77
	.dc.w	oelipse-icons	;78
	.dc.w	okidney-icons	;79
	.dc.w	opolygon-icons	;80
	.dc.w	frect-icons	;81
	.dc.w	frndrect-icons	;82
	.dc.w	fellips-icons	;83
	.dc.w	fkidney-icons	;84
	.dc.w	fpolygon-icons	;85
	.dc.w	oshape-icons	;86
	.dc.w	nullthik-icons	;87
	.dc.w	eff10-icons	;88
	.dc.w	ef10null-icons	;89
	.dc.w	poiynt-icons	;90
*
*  "Icons"
*
icons:
*
*   1st two words are width x height
*
block:
	.dc.w	fatpxlw,fatpxlh
	.dc.w	%0000000000000000
	.dc.w	%0111110000000000
	.dc.w	%0111110000000000
	.dc.w	%0111110000000000
	.dc.w	%0111110000000000
	.dc.w	%0111110000000000
*
block1:
	.dc.w	18,9
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
	.dc.l	%11111111111111111100000000000000
*
block2:
	.dc.w	5,3
	.dc.w	%0010000000000000
	.dc.w	%0111000000000000
	.dc.w	%1111100000000000
*
block3:
	.dc.w	4,9
	.dc.w	%1111000000000000
	.dc.w	%1110000000000000
	.dc.w	%1100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1100000000000000
	.dc.w	%1110000000000000
	.dc.w	%1111000000000000
block4:
	.dc.w	4,9
	.dc.w	%1111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0011000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0011000000000000
	.dc.w	%0111000000000000
	.dc.w	%1111000000000000
alinleft:
	.dc.w	9,5
	.dc.w	$0800,$1800,$3F00,$1800,$0800
alinrite:
	.dc.w	9,5
	.dc.w	$0800,$0C00,$7E00,$0C00,$0800
alinmid:
	.dc.w	9,5
	.dc.w	$1400,$1400,$1400,$1400,$1400
colblok:
	.dc.w	24,11
	.dc.w	$FFFF,$FF00,$FFFF,$FF00,$FFFF,$FF00,$FFFF,$FF00
	.dc.w	$FFFF,$FF00,$FFFF,$FF00,$FFFF,$FF00,$FFFF,$FF00
	.dc.w	$FFFF,$FF00,$FFFF,$FF00,$FFFF,$FF00
larrow:
	.dc.w	9,11
	.dc.w	$0000,$0700,$0f00,$1f00,$3f00,$7f00,$3f00,$1f00
	.dc.w	$0f00,$0700,$0000
rarrow:
	.dc.w	9,11
	.dc.w	$0000,$7000,$7800,$7c00,$7e00,$7f00,$7e00,$7c00
	.dc.w	$7800,$7000,$0000
exitboxh:
*	.dc.w	8,64
*	.dc.w	$FF00,$8000,$8000,$BE00,$8400,$8800,$9000,$BE00
*	.dc.w	$8000,$A200,$AA00,$AA00,$BE00,$8000,$A200,$AA00
*	.dc.w	$AA00,$BE00,$8000,$9200,$AA00,$AC00,$A800,$BE00
*	.dc.w	$8000,$A200,$A200,$A200,$A200,$9C00,$8000,$A400
*	.dc.w	$AA00,$AA00,$AA00,$9200,$8000,$8000,$8000,$8000
*	.dc.w	$8200,$8200,$8200,$BE00,$8000,$8200,$8200,$8200
*	.dc.w	$BE00,$8000,$BE00,$8200,$8200,$8200,$BC00,$8000
*	.dc.w	$A000,$A800,$A800,$A800,$BE00,$8000,$8000,$FF00
*
	.dc.w	8,64
	.dc.w	$FFFF,$8001,$8001,$BE01,$8401,$8801,$9001,$BE01
	.dc.w	$8001,$A201,$AA01,$AA39,$BE45,$8045,$A245,$AA7D
	.dc.w	$AA01,$BE01,$8001,$9201,$AA01,$AC01,$A801,$BE01
	.dc.w	$8045,$A27D,$A245,$A201,$A201,$9C01,$8001,$A401
	.dc.w	$AA01,$AA01,$AA01,$9225,$8055,$8059,$8051,$807D
	.dc.w	$8201,$8201,$8201,$BE01,$8001,$8201,$8201,$825D
	.dc.w	$BE55,$8045,$BE45,$8239,$8201,$8201,$BC01,$8001
	.dc.w	$A001,$A801,$A801,$A801,$BE01,$8001,$8001,$FFFF
*
exitboxf:
colorscr:
	.dc.w	16,16
	.dc.w	$0000,$0000,$0000,$0000,$07f0,$0e38,$1a2c,$3226
	.dc.w	$6223,$3226,$1a2c,$0e38,$07f0,$0000,$0000,$0000
hand:
	.dc.w	16,16
	.dc.w	$0300,$1CB0,$2448,$2224,$7112,$9882,$8402,$4201
	.dc.w	$7001,$9801,$8401,$4000,$3000,$0E00,$01C0,$0030
pencil:
	.dc.w	16,16
	.dc.w	$7fb4,$0000,$7800,$7400,$6200,$3100,$1880,$0c40
	.dc.w	$0620,$0310,$0188,$00c4,$0066,$003c,$0018,$0000
copybox:
	.dc.w	16,16
	.dc.w	$0000,$6DB0,$4010,$0000,$4010,$4010,$0000,$4010
	.dc.w	$4010,$0010,$4010,$6DEF,$0010,$0010,$0010,$0010
mrtee:
	.dc.w	16,16
	.dc.w	$0000,$7FFE,$4002,$5E7A,$6246,$0240,$0240,$0240
	.dc.w	$0240,$0240,$0240,$0240,$0660,$0810,$0FF0,$0000
linedrw:
	.dc.w	16,16
	.dc.w	$0000,$4000,$2000,$1000,$0800,$0400,$0200,$0110
	.dc.w	$0090,$0050,$0010,$01EF,$0010,$0010,$0010,$0010
bucket:
	.dc.w	16,16
	.dc.w	$0000,$01c0,$0330,$0708,$0c84,$185c,$303e,$601e
	.dc.w	$402e,$4056,$60a6,$3142,$1a82,$0700,$0002,$0000
sprayc:
	.dc.w	16,16
	.dc.w	$0AA0,$5114,$C042,$AF10,$7680,$2CC0,$5920,$7210
	.dc.w	$6118,$30A4,$184E,$0C1A,$0634,$0368,$01D0,$00E0
brush:
	.dc.w	16,16
	.dc.w	$1FDA,$2AF0,$5360,$5190,$48C0,$A460,$9270,$89B0
	.dc.w	$C560,$62E0,$35D0,$1BE8,$0E74,$003A,$001E,$000C
disket:
	.dc.w	16,16
	.dc.w	$0000,$3ffc,$4f12,$4f12,$4f12,$4f12,$4fe2,$4002
	.dc.w	$4ff2,$581a,$500a,$500a,$500a,$500a,$3ffc,$0000
erase:
	.dc.w	16,16
	.dc.w	$0600,$0f00,$1980,$30c0,$6060,$6030,$7018,$5808
	.dc.w	$4c1c,$2634,$1374,$09d8,$0550,$0360,$0140,$0080
shapes:
	.dc.w	16,16
	.dc.w	$0C00,$3F00,$7F80,$FFC0,$FFC0,$FFDF,$7F9F,$3F1F
	.dc.w	$0C1F,$001F,$3F9F,$7F1F,$FE1F,$7F1F,$3F80,$1FC0
jacknife:
	.dc.w	16,16
	.dc.w	$0000,$3800,$6400,$5200,$4500,$2A80,$3540,$2AA0
	.dc.w	$2D50,$26A8,$2354,$25A2,$24CA,$2866,$303C,$2000
*
brush1:
	.dc.w	2,2
	.dc.w	$C000,$C000
brush2:
	.dc.w	3,3
	.dc.w	$E000,$E000,$E000
brush3:
	.dc.w	4,4
	.dc.w	$F000,$F000,$F000,$F000
brush4:
	.dc.w	6,6
	.dc.w	$FC00,$FC00,$FC00,$FC00,$FC00,$FC00
brush5:
	.dc.w	8,8
	.dc.w	$FF00,$FF00,$FF00,$FF00,$FF00,$FF00,$FF00,$FF00
*
brush6:
	.dc.w	3,3
	.dc.w	$4000,$E000,$4000
brush7:
	.dc.w	4,4
	.dc.w	$6000,$F000,$F000,$6000
brush8:
	.dc.w	5,4
	.dc.w	$7000,$F800,$F800,$7000
brush9:
	.dc.w	5,5
	.dc.w	$7000,$F800,$F800,$F800,$7000
brush10:
	.dc.w	7,7
	.dc.w	$3800,$7C00,$FE00,$FE00,$FE00,$7C00,$3800
*
*
brush11:
	.dc.w	2,2
	.dc.w	$4000,$8000
brush12:
	.dc.w	3,3
	.dc.w	$2000,$4000,$8000
brush13:
	.dc.w	4,4
	.dc.w	$1000,$2000,$4000,$8000
brush14:
	.dc.w	5,5
	.dc.w	$0800,$1000,$2000,$4000,$8000
brush15:
	.dc.w	6,6
	.dc.w	$0400,$0800,$1000,$2000,$4000,$8000
*
*
brush16:
	.dc.w	2,2
	.dc.w	$8000,$4000
brush17:
	.dc.w	3,3
	.dc.w	$8000,$4000,$2000
brush18:
	.dc.w	4,4
	.dc.w	$8000,$4000,$2000,$1000
brush19:
	.dc.w	5,5
	.dc.w	$8000,$4000,$2000,$1000,$0800
brush20:
	.dc.w	6,6
	.dc.w	$8000,$4000,$2000,$1000,$0800,$0400
*
*
brush21:
	.dc.w	1,2
	.dc.w	$8000,$8000
brush22:
	.dc.w	1,3
	.dc.w	$8000,$8000,$8000
brush23:
	.dc.w	1,4
	.dc.w	$8000,$8000,$8000,$8000
brush24:
	.dc.w	1,5
	.dc.w	$8000,$8000,$8000,$8000,$8000
brush25:
	.dc.w	1,6
	.dc.w	$8000,$8000,$8000,$8000,$8000,$8000
*
*
brush26:
	.dc.w	2,1
	.dc.w	$C000
brush27:
	.dc.w	3,1
	.dc.w	$E000
brush28:
	.dc.w	4,1
	.dc.w	$F000
brush29:
	.dc.w	5,1
	.dc.w	$F800
brush30:
	.dc.w	6,1
	.dc.w	$FC00
*
*
brush31:
	.dc.w	1,1
	.dc.w	$8000
brush32:
	.dc.w	3,3
	.dc.w	$A000,$4000,$A000
brush33:
	.dc.w	5,5
	.dc.w	$2000,$0000,$A800,$0000,$2000
brush34:
	.dc.w	7,7
	.dc.w	$2800,$5400,$AA00,$5400,$AA00,$5400,$2800
brush35:
	.dc.w	7,9
	.dc.w	$1000,$0000,$A200,$0800,$5000,$0800,$9200,$0000,$1000
brush36:
	.dc.w	16,16
	.dc.w	$0100,$1010,$0080,$0400,$8022,$0200,$2088,$0420
	.dc.w	$9001,$0108,$0840,$4202,$0020,$1100,$0010,$0200
*
brush37:
	.dc.w	13,11
	.dc.w	$0200,$0880,$2220,$8888,$2220,$8888,$2220
	.DC.W	$8888,$2220,$0880,$0200
brush38:
	.dc.w	9,9
	.dc.w	$2A00,$0000,$AA80,$0000,$AA80,$0000,$AA80,$0000,$2A00
*
replace:
	.dc.w	10,14
	.dc.w	$DD00,$8100,$0100,$80C0,$81C0,$81C0,$01C0,$80C0
	.dc.w	$81C0,$81C0,$01C0,$EEC0,$1FC0,$1FC0
trans:
	.dc.w	10,14
	.dc.w	$DD00,$8100,$0100,$9EC0,$9FC0,$9FC0,$1FC0,$9EC0
	.dc.w	$9FC0,$9FC0,$1FC0,$EEC0,$1FC0,$1FC0
*
*replace:
*	.dc.w	10,10
*	.dc.w	$DD00,$8100,$01C0,$80C0,$81C0,$81C0,$01C0,$EEC0,$3FC0,$3FC0
*
*trans:
*	.dc.w	10,10
*	.dc.w	$DD00,$8100,$3FC0,$BEC0,$BFC0,$BFC0,$3FC0,$EEC0,$3FC0,$3FC0
eraser:
	.dc.w	11,15
	.dc.w	$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0
	.dc.w	$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0,$FFE0
animate:
	.dc.w	16,16
	.dc.w	$0180,$03C0,$07E0,$07E0,$03D8,$01BC,$67FE,$7FFE
	.dc.w	$7FBC,$6798,$0300,$0480,$0480,$0840,$0840,$0000
*dots:
*	.dc.w	16,16
*	.dc.w	$0000,$0000,$007c,$00fc,$00c0,$00c0,$00e0,$0070
*	.dc.w	$0038,$001c,$000c,$380c,$38fc,$38f8,$0000,$0000
*
*
*   percent sign
*
misc:
*	.dc.w	16,16
*	.dc.w	$0000,$0000,$1C04,$220C,$2218,$2230,$1C60,$00C0
*	.dc.w	$0180,$031C,$0622,$0C22,$1822,$101C,$0000,$0000
*
	.dc.w	16,16
	.dc.w	$0000,$0780,$0CC0,$1860,$1860,$0CC0,$0780,$0E00
	.dc.w	$199E,$30CC,$3068,$3030,$3878,$1FDC,$0F8E,$0000
*
dwnara:
	.dc.w	5,6
	.dc.w	$2000,$2000,$2000,$f800,$7000,$2000
upara:
	.dc.w	5,6
	.dc.w	$2000,$7000,$f800,$2000,$2000,$2000
lftara:
	.dc.w	5,9
	.dc.w	$0800,$1000,$2000,$4000,$8000,$4000,$2000,$1000,$0800
rgtara:
	.dc.w	5,9
	.dc.w	$8000,$4000,$2000,$1000,$0800,$1000,$2000,$4000,$8000
lilcpybx:
	.dc.w	11,11
	.dc.w	$db00,$8100,$0,$8100,$8100,$0,$8100,$dae0,$0100,$0100,$0100
*
cswap:
	.dc.w	20,15
	.dc.w	$007C,$0000,$0182,$8000,$0201,$8000,$0403,$8000
	.dc.w	$0000,$0000,$3DFB,$C000,$7DFB,$E000,$FDFB,$F000
	.dc.w	$7DFB,$E000,$3DFB,$C000,$0000,$0000,$1C02,$0000
	.dc.w	$1804,$0000,$1410,$0000,$0140,$0000
stretch:
	.dc.w	20,13
	.dc.w	$EEEE,$C000,$0000,$0000,$8FFC,$4000
	.dc.w	$1E00,$0000,$8FFC,$4000,$001E,$0000,$801e,$4000
	.dc.w	$001e,$0000,$8ffc,$4000,$8000,$5000,$DDDD,$D000
	.dc.w	$0000,$3000,$0000,$F000
*
*  open rectangle
*
orect:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0FFF,$0000
	.dc.w	$0801,$0000,$0801,$0000,$0801,$0000,$0801,$0000
	.dc.w	$0801,$0000,$0801,$0000,$0801,$0000,$0801,$0000
	.dc.w	$0801,$0000,$0801,$0000,$0801,$0000,$0801,$0000
	.dc.w	$0801,$0000,$0FFF,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*  open rounded rectangle
*
orndrect:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$03FC,$0000
	.dc.w	$0606,$0000,$0C03,$0000,$0801,$0000,$0801,$0000
	.dc.w	$0801,$0000,$0801,$0000,$0801,$0000,$0801,$0000
	.dc.w	$0801,$0000,$0801,$0000,$0801,$0000,$0C03,$0000
	.dc.w	$0606,$0000,$03FC,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*   open ellipse
*
oelipse:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$00F0,$0000
	.dc.w	$030C,$0000,$0402,$0000,$0801,$0000,$0801,$0000
	.dc.w	$1000,$8000,$1000,$8000,$1000,$8000,$1000,$8000
	.dc.w	$1000,$8000,$0801,$0000,$0801,$0000,$0402,$0000
	.dc.w	$030C,$0000,$00F0,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
* open kidney
*
okidney:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0078,$0000
	.dc.w	$0184,$0000,$0202,$0000,$0402,$0000,$080C,$0000
	.dc.w	$0810,$0000,$1010,$0000,$1008,$0000,$1006,$0000
	.dc.w	$1001,$0000,$0800,$8000,$0800,$8000,$0401,$0000
	.dc.w	$0386,$0000,$0078,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*
*  open polygon
*
opolygon:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$3FF8,$0000
	.dc.w	$1004,$0000,$0802,$0000,$0401,$0000,$0202,$0000
	.dc.w	$0404,$0000,$0808,$0000,$1010,$0000,$2008,$0000
	.dc.w	$1004,$0000,$0802,$0000,$0401,$0000,$0200,$8000
	.dc.w	$01FF,$C000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*
*  filled rectangle
*
frect:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0FFF,$0000
	.dc.w	$0AAB,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$0AAB,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$0AAB,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$0AAB,$0000,$0FFF,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*  filled rounded rectangle
*
frndrect:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$03FC,$0000
	.dc.w	$06AA,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$0AAB,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$0AAB,$0000,$0D55,$0000,$0AAB,$0000,$0D55,$0000
	.dc.w	$06AA,$0000,$03FC,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*  filled ellipse
*
fellips:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$00F0,$0000
	.dc.w	$035C,$0000,$06AA,$0000,$0D55,$0000,$0AAB,$0000
	.dc.w	$1555,$8000,$1AAA,$8000,$1555,$8000,$1AAA,$8000
	.dc.w	$1555,$8000,$0AAB,$0000,$0D55,$0000,$06AA,$0000
	.dc.w	$035C,$0000,$00F0,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*  filled kidney
*
fkidney:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0078,$0000
	.dc.w	$01D4,$0000,$02AA,$0000,$0556,$0000,$0AAC,$0000
	.dc.w	$0D50,$0000,$1AB0,$0000,$1558,$0000,$1AAE,$0000
	.dc.w	$1555,$0000,$0AAA,$8000,$0D55,$8000,$06AB,$0000
	.dc.w	$03D6,$0000,$0078,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*  filled polygon
*
fpolygon:
	.dc.w	20,21
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$3FF8,$0000
	.dc.w	$1554,$0000,$0AAA,$0000,$0555,$0000,$02AA,$0000
	.dc.w	$0554,$0000,$0AA8,$0000,$1550,$0000,$2AA8,$0000
	.dc.w	$1554,$0000,$0AAA,$0000,$0555,$0000,$02AA,$8000
	.dc.w	$01FF,$C000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000
*
*
*  open shapes icon
*
oshape:
	.dc.w	16,16
	.dc.w	$0C00,$3300,$4080,$8040,$8040,$805F,$4091,$3311
	.dc.w	$0C11,$0011,$3F91,$4111,$8211,$411F,$2080,$1FC0
*
*
nullthik:
	.dc.w	19,1
	.dc.w	$AAAA,$A000
*
*  "F10" icon
*
eff10:
	.dc.w	14,5
	.dc.w	$F938,$834C,$F154,$8164,$8138
ef10null:
	.dc.w	1,1
	.dc.w	0
*
*
*
poiynt:
	.dc.w	16,20
	.dc.w	$6186,$9249,$F3CF,$9249,$9249,$9249,$9249,$9249
	.dc.w	$9249,$9249,$9249,$9249,$93C9,$9449,$9849,$9FC9
	.dc.w	$8009,$800A,$800C,$FFF8
*
*  fake neo icon in icon list
*
*
*   "NEO" icon
*
*neoike:
*	.dc.w	16,16
*	.dc.w	$0000,$0000
*	.dc.w	$0000,$0000
*	.dc.w	$0000,$8BCE
*	.dc.w	$CA11,$AB91
*	.dc.w	$9A11,$8BCE
*	.dc.w	$0000,$0000
*	.dc.w	$0000,$0000
*	.dc.w	$0000,$0000
*
*
*
neopaint:
*
*   Large NEOchrome graphic
*
*    pixels/scanline    = $007C (words/scanline: $0020)
*  # scanlines (height) = $001D
*
*
*
	.dc.w	$0FCF,$0000,$0FCF,$0FCF,$FFFF,$0000,$FFFF,$FFFF
	.dc.w	$7FC0,$0000,$7FC0,$7FC0,$00FE,$0000,$00FE,$00FE
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0FEF,$0000,$0868,$0868,$FFFF,$0000,$0001,$0001
	.dc.w	$FFF0,$0000,$C070,$C070,$00FE,$0000,$0082,$0082
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0FFF,$0303,$0838,$0B3B,$FD57,$9BB8,$0445,$9BB9
	.dc.w	$F7F8,$1900,$0418,$1B18,$00D6,$0010,$0082,$00BA
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0FFF,$0101,$0A9A,$0919,$FF57,$11B8,$8EEC,$1110
	.dc.w	$D5F8,$3B80,$6EC8,$1108,$00D6,$0010,$0082,$00BA
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0FFF,$0383,$0848,$0B8B,$FD57,$9BB8,$0444,$9BB8
	.dc.w	$57F8,$B900,$4448,$BBA8,$00D6,$0010,$0082,$00BA
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0EFE,$0101,$0AE2,$0901,$EFFF,$1000,$8C00,$1000
	.dc.w	$4EF8,$B1A0,$E0E8,$1108,$00C6,$0010,$0082,$00BA
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0EAE,$03F3,$0840,$0BB3,$EBFF,$9C00,$05FE,$99FE
	.dc.w	$1FB8,$E040,$4448,$A4A8,$00C6,$0010,$0082,$00BA
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dc.w	$0EAE,$0151,$0AEA,$0911,$EBFF,$1400,$8C02,$1002
	.dc.w	$1FBB,$E0E0,$EEEB,$0E0B,$FEC7,$0010,$FE83,$FEBB
	.dc.w	$FFFF,$0000,$FFFF,$FFFF,$1FF7,$0000,$1FF7,$1FF7
	.dc.w	$FFF9,$0000,$FFF9,$FFF9,$FF00,$0000,$FF00,$FF00
	.dc.w	$0BBB,$06EE,$0804,$0BBB,$9912,$EEED,$0442,$9BBA
	.dc.w	$0AAE,$F151,$4A4E,$AAAE,$0390,$FC47,$0380,$03B8
	.dc.w	$0C01,$F3FE,$0C01,$0C01,$F01C,$0FE3,$F01C,$F01C
	.dc.w	$000F,$FFF0,$000F,$000F,$01C0,$FE00,$01C0,$01C0
	.dc.w	$0B9B,$0464,$0A8E,$0911,$9B12,$64ED,$8EEA,$1112
	.dc.w	$0AA8,$F1F7,$EAE8,$0A08,$B891,$EF44,$E880,$10BB
	.dc.w	$0518,$5A67,$4444,$A598,$4385,$BC7A,$4444,$4385
	.dc.w	$0024,$FFFB,$4444,$8A24,$6C60,$BB80,$1060,$6C60
	.dc.w	$0B8F,$06FE,$0804,$0B8B,$9D52,$EEED,$0442,$9BBA
	.dc.w	$4AE3,$F15C,$4A40,$AAA3,$FC15,$45C4,$4404,$BA3B
	.dc.w	$51FF,$4EEE,$40EE,$B111,$1F51,$EEEE,$0EE0,$1111
	.dc.w	$5571,$EECF,$EEE1,$1110,$FF20,$11C0,$BB20,$4420
	.dc.w	$0AA6,$045C,$0AA6,$0921,$8C02,$67FD,$8C02,$1002
	.dc.w	$4AE6,$F1FE,$EAE6,$0A01,$EE04,$EEC4,$EE04,$113B
	.dc.w	$406E,$4644,$4044,$B9BB,$AEC0,$446E,$0440,$BBB9
	.dc.w	$4463,$EEEF,$4441,$BBB2,$BBA0,$BBC0,$1120,$EEA0
	.dc.w	$0AB2,$06CE,$0830,$0BB3,$8DFE,$EE01,$05FE,$99FE
	.dc.w	$4AE6,$F15C,$4A44,$AAA3,$8C04,$74C7,$0404,$8B38
	.dc.w	$40E2,$C6FE,$40E2,$3901,$AC40,$EFEE,$AC68,$1011
	.dc.w	$4463,$FFCD,$CE63,$0010,$83A0,$3940,$83A0,$4420
	.dc.w	$0ABA,$0444,$0ABA,$0939,$8D02,$6601,$8D02,$1102
	.dc.w	$4AE6,$F1FE,$EAE6,$0A01,$2601,$DEC6,$2601,$2139
	.dc.w	$0048,$C677,$0048,$3988,$2900,$C6EE,$0100,$3939
	.dc.w	$4463,$FFEF,$4441,$8A32,$93A0,$EFC0,$1120,$92A0
	.dc.w	$0282,$06C6,$0828,$0BAB,$8800,$EA01,$0102,$9D02
	.dc.w	$00A2,$B118,$0A00,$EAE7,$0000,$88C4,$7003,$773B
	.dc.w	$0080,$46A0,$809F,$B95F,$2800,$6C6E,$ABA8,$9391
	.dc.w	$0022,$BB8C,$8A22,$4451,$8280,$7C40,$82A0,$0120
	.dc.w	$07C7,$0545,$0BAB,$0828,$FA01,$7201,$9902,$0502
	.dc.w	$11BB,$B1BB,$AAA3,$4A44,$8FD4,$8FD4,$5012,$502A
	.dc.w	$5720,$5720,$9110,$A8D0,$7C57,$547F,$9291,$AAA8
	.dc.w	$31BE,$BBBE,$0010,$CE63,$EEC0,$EEC0,$4420,$BBA0
	.dc.w	$07C7,$07C7,$0929,$0AAA,$FA01,$FA01,$1102,$8D02
	.dc.w	$11BB,$B119,$0A01,$EAE6,$8054,$8054,$5F92,$5FAA
	.dc.w	$57A0,$57A0,$9190,$A850,$7C57,$7C7F,$BAB9,$8280
	.dc.w	$31BE,$BB9C,$8A32,$4441,$EEC0,$4440,$EEA0,$1120
	.dc.w	$07C7,$0545,$0BAB,$0828,$FA01,$7201,$9902,$0502
	.dc.w	$11BB,$B1BB,$AAA3,$4A44,$8054,$8054,$4092,$40AA
	.dc.w	$5720,$5720,$9110,$A8D0,$7C57,$547F,$9291,$AAA8
	.dc.w	$31BE,$BBBE,$0010,$CE63,$EEC0,$EEC0,$4420,$BBA0
	.dc.w	$07C7,$07C7,$0929,$0AAA,$FE01,$FA01,$1102,$8D02
	.dc.w	$51FF,$B119,$0A01,$EAE6,$8054,$8054,$4092,$40AA
	.dc.w	$57E0,$57A0,$9190,$A850,$7C57,$7C7F,$BAB9,$8280
	.dc.w	$75FF,$BB9C,$8A32,$4441,$FFC0,$7FC0,$8020,$0020
	.dc.w	$06C6,$0545,$0BAB,$0828,$EE01,$7201,$9902,$0502
	.dc.w	$51FE,$B1BB,$AAA3,$4A44,$8044,$8054,$4092,$40AA
	.dc.w	$4660,$5720,$9110,$A8D0,$6C46,$547F,$9291,$AAA8
	.dc.w	$75EF,$BBBE,$0010,$CE63,$C000,$C000,$3FE0,$BFE0
	.dc.w	$06C6,$07C7,$0929,$0AAA,$EE01,$FA01,$1102,$8D02
	.dc.w	$51FE,$B119,$0A01,$EAE6,$8044,$8054,$4092,$40AA
	.dc.w	$46E0,$57A0,$9190,$A850,$6C46,$7C7F,$BAB9,$8280
	.dc.w	$75EF,$BB9C,$8A32,$4441,$C000,$4000,$A000,$2000
	.dc.w	$0EEE,$0D6D,$0383,$0828,$EB03,$7703,$9800,$0502
	.dc.w	$1FBA,$FFFF,$A0A3,$4E44,$E0C6,$E0D6,$0010,$60AA
	.dc.w	$C630,$D770,$1100,$A8D0,$EFC6,$D7FF,$1011,$ABA8
	.dc.w	$31AE,$FFFF,$0010,$CE63,$F000,$F000,$0000,$B000
	.dc.w	$0AAA,$0BAB,$0545,$0AAA,$89FE,$9DFE,$7201,$8DFE
	.dc.w	$04A2,$E445,$1B19,$E4E6,$3F82,$3F92,$C054,$3FAA
	.dc.w	$8090,$91D0,$57A0,$A850,$A900,$B939,$7EFF,$8100
	.dc.w	$0022,$CE51,$BBBE,$4441,$9FF0,$1FF0,$E000,$1FF0
	.dc.w	$0BAB,$0828,$07C7,$0828,$9800,$0400,$FBFF,$0400
	.dc.w	$11A3,$E0E6,$BFBB,$4044,$8012,$8002,$FFD4,$002A
	.dc.w	$9110,$8050,$5720,$A8D0,$B811,$8468,$5397,$AC68
	.dc.w	$0032,$CE63,$319C,$CE63,$C010,$8010,$7FE0,$8010
	.dc.w	$0BAB,$0AAA,$0545,$0AAA,$9D54,$8EEC,$7113,$8EEC
	.dc.w	$57E7,$EC44,$1119,$EEE6,$FD12,$4402,$11D4,$EE2A
	.dc.w	$91D0,$80D0,$57A0,$A850,$BF51,$AEE8,$7BBF,$8440
	.dc.w	$4473,$CE41,$BBBE,$4441,$FFD0,$1110,$EEE0,$1110
	.dc.w	$0BAB,$0828,$07C7,$0828,$9F54,$04EC,$FBBB,$0444
	.dc.w	$55C3,$6EC2,$BBBF,$4440,$FF12,$EE02,$BBD4,$442A
	.dc.w	$9150,$8050,$5720,$A8D0,$9FD1,$8460,$711F,$8EE0
	.dc.w	$4471,$CE61,$319E,$CE61,$FFD0,$BB90,$4460,$BB90
	.dc.w	$0BAB,$0AAA,$0545,$0AAA,$9D55,$8EED,$7112,$8EED
	.dc.w	$1718,$0C18,$F1E7,$0E18,$FD12,$4402,$11D4,$EE2A
	.dc.w	$91D0,$80D0,$57A0,$A850,$C745,$C6C4,$3BBB,$C444
	.dc.w	$4474,$CE44,$BBBB,$4444,$7FD0,$1110,$EEE0,$1110
	.dc.w	$0828,$0828,$07C7,$0828,$0001,$0001,$FFFE,$0001
	.dc.w	$C07E,$C07E,$3F81,$C07E,$0002,$0002,$FFFC,$0002
	.dc.w	$8010,$8010,$7FE0,$8010,$701C,$701C,$0FE3,$701C
	.dc.w	$0007,$0007,$FFF8,$0007,$0010,$0010,$FFE0,$0010
	.dc.w	$0FEF,$0FEF,$0000,$0FEF,$FFFF,$FFFF,$0000,$FFFF
	.dc.w	$7FC3,$7FC3,$0000,$7FC3,$FFFE,$FFFE,$0000,$FFFE
	.dc.w	$FFF0,$FFF0,$0000,$FFF0,$1FF7,$1FF7,$0000,$1FF7
	.dc.w	$FFFD,$FFFD,$0000,$FFFD,$FFF0,$FFF0,$0000,$FFF0
*
*
*
*
*
*  Major (exhaustive) pallet
*
bigpalt:
	.dc.w	$0070,$0071,$0171,$0271,$0371,$0471,$0571,$0671
	.dc.w	$0771,$0761,$0751,$0741,$0731,$0721,$0711,$0701
	.dc.w	$0170,$0060,$0061,$0161,$0261,$0361,$0461,$0561
	.dc.w	$0661,$0651,$0641,$0631,$0621,$0611,$0601,$0702
	.dc.w	$0270,$0160,$0050,$0051,$0151,$0251,$0351,$0451
	.dc.w	$0551,$0541,$0531,$0521,$0511,$0501,$0602,$0712
	.dc.w	$0370,$0260,$0150,$0040,$0041,$0141,$0241,$0341
	.dc.w	$0441,$0431,$0421,$0411,$0401,$0502,$0612,$0722
	.dc.w	$0470,$0360,$0250,$0140,$0030,$0031,$0131,$0231
	.dc.w	$0331,$0321,$0311,$0301,$0402,$0512,$0622,$0732
	.dc.w	$0570,$0460,$0350,$0240,$0130,$0020,$0021,$0121
	.dc.w	$0221,$0211,$0201,$0302,$0412,$0522,$0632,$0742
	.dc.w	$0670,$0560,$0450,$0340,$0230,$0120,$0010,$0011
	.dc.w	$0111,$0101,$0202,$0312,$0422,$0532,$0642,$0752
	.dc.w	$0770,$0660,$0550,$0440,$0330,$0220,$0110,$0000
	.dc.w	$0001,$0102,$0212,$0322,$0432,$0542,$0652,$0762
*
	.dc.w	$0760,$0650,$0540,$0430,$0320,$0210,$0100,$0003
	.dc.w	$0002,$0112,$0222,$0332,$0442,$0552,$0662,$0772
	.dc.w	$0750,$0640,$0530,$0420,$0310,$0200,$0103,$0113
	.dc.w	$0013,$0012,$0122,$0232,$0342,$0452,$0562,$0672
	.dc.w	$0740,$0630,$0520,$0410,$0300,$0203,$0213,$0223
	.dc.w	$0123,$0023,$0022,$0132,$0242,$0352,$0462,$0572
	.dc.w	$0730,$0620,$0510,$0400,$0303,$0313,$0323,$0333
	.dc.w	$0233,$0133,$0033,$0032,$0142,$0252,$0362,$0472
	.dc.w	$0720,$0610,$0500,$0403,$0413,$0423,$0433,$0443
	.dc.w	$0343,$0243,$0143,$0043,$0042,$0152,$0262,$0372
	.dc.w	$0710,$0600,$0503,$0513,$0523,$0533,$0543,$0553
	.dc.w	$0453,$0353,$0253,$0153,$0053,$0052,$0162,$0272
	.dc.w	$0700,$0603,$0613,$0623,$0633,$0643,$0653,$0663
	.dc.w	$0563,$0463,$0363,$0263,$0163,$0063,$0062,$0172
	.dc.w	$0703,$0713,$0723,$0733,$0743,$0753,$0763,$0773
	.dc.w	$0673,$0573,$0473,$0373,$0273,$0173,$0073,$0072
*
	.dc.w	$0707,$0704,$0714,$0724,$0734,$0744,$0754,$0764
	.dc.w	$0774,$0674,$0574,$0474,$0374,$0274,$0174,$0074
	.dc.w	$0717,$0607,$0604,$0614,$0624,$0634,$0644,$0654
	.dc.w	$0664,$0564,$0464,$0364,$0264,$0164,$0064,$0075
	.dc.w	$0727,$0617,$0507,$0504,$0514,$0524,$0534,$0544
	.dc.w	$0554,$0454,$0354,$0254,$0154,$0054,$0065,$0175
	.dc.w	$0737,$0627,$0517,$0407,$0404,$0414,$0424,$0434
	.dc.w	$0444,$0344,$0244,$0144,$0044,$0055,$0165,$0275
	.dc.w	$0747,$0637,$0527,$0417,$0307,$0304,$0314,$0324
	.dc.w	$0334,$0234,$0134,$0034,$0045,$0155,$0265,$0375
	.dc.w	$0757,$0647,$0537,$0427,$0317,$0207,$0204,$0214
	.dc.w	$0224,$0124,$0024,$0035,$0145,$0255,$0365,$0475
	.dc.w	$0767,$0657,$0547,$0437,$0327,$0217,$0107,$0104
	.dc.w	$0114,$0014,$0025,$0135,$0245,$0355,$0465,$0575
	.dc.w	$0777,$0667,$0557,$0447,$0337,$0227,$0117,$0007
	.dc.w	$0004,$0015,$0125,$0235,$0345,$0455,$0565,$0675
*
	.dc.w	$0677,$0567,$0457,$0347,$0237,$0127,$0017,$0006
	.dc.w	$0005,$0115,$0225,$0335,$0445,$0555,$0665,$0775
	.dc.w	$0577,$0467,$0357,$0247,$0137,$0027,$0016,$0116
	.dc.w	$0106,$0105,$0215,$0325,$0435,$0545,$0655,$0765
	.dc.w	$0477,$0367,$0257,$0147,$0037,$0026,$0126,$0226
	.dc.w	$0216,$0206,$0205,$0315,$0425,$0535,$0645,$0755
	.dc.w	$0377,$0267,$0157,$0047,$0036,$0136,$0236,$0336
	.dc.w	$0326,$0316,$0306,$0305,$0415,$0525,$0635,$0745
	.dc.w	$0277,$0167,$0057,$0046,$0146,$0246,$0346,$0446
	.dc.w	$0436,$0426,$0416,$0406,$0405,$0515,$0625,$0735
	.dc.w	$0177,$0067,$0056,$0156,$0256,$0356,$0456,$0556
	.dc.w	$0546,$0536,$0526,$0516,$0506,$0505,$0615,$0725
	.dc.w	$0077,$0066,$0166,$0266,$0366,$0466,$0566,$0666
	.dc.w	$0656,$0646,$0636,$0626,$0616,$0606,$0605,$0715
	.dc.w	$0076,$0176,$0276,$0376,$0476,$0576,$0676,$0776
	.dc.w	$0766,$0756,$0746,$0736,$0726,$0716,$0706,$0705
	.dc.w	$0000
